<?php
/**
 * A place for general functions
 */

// Comment Layout
if ( ! function_exists( 'geodirf_comments' ) ) {
	/**
	 * @param $comment
	 * @param $args
	 * @param $depth
	 */
	function geodirf_comments( $comment, $args, $depth ) {
		$GLOBALS['comment'] = $comment; ?>

	<div id="comment-<?php comment_ID(); ?>" <?php comment_class( 'cf' ); ?>>
		<article class="cf">
			<header class="comment-author vcard">
				<?php
				// custom gravatar call
				/**
				 * Filter to modify comment avatar size
				 *
				 * You can use this filter to change comment avatar size.
				 *
				 * @since 1.2.5
				 * @package GeoDirectory_framework
				 */
				$avatar_size = apply_filters( 'geodir_comment_avatar_size', 44 );
				echo get_avatar( $comment, $avatar_size );
				// end custom gravatar call ?>
				<?php printf( __( '<cite class="fn">%1$s</cite> %2$s', "geodirectory_framework" ), get_comment_author_link(), edit_comment_link( __( '(Edit)', "geodirectory_framework" ), '  ', '' ) ) ?>
				<time datetime="<?php echo comment_time( 'c' ); ?>"><a
						href="<?php echo htmlspecialchars( get_comment_link( $comment->comment_ID ) ) ?>">
						<?php comment_time( __( 'F jS, Y', "geodirectory_framework" ) ); ?>
					</a></time>
			</header>
			<?php if ( $comment->comment_approved == '0' ) : ?>
				<div class="alert alert-info">
					<p>
						<?php _e( 'Your comment is awaiting moderation.', "geodirectory_framework" ) ?>
					</p>
				</div>
			<?php endif; ?>
			<section class="comment_content cf">
				<?php comment_text() ?>
			</section>
			<?php comment_reply_link( array_merge( $args, array(
				'depth'     => $depth,
				'max_depth' => $args['max_depth']
			) ) ) ?>
		</article>

		<?php
	}
}

/*********************
 * PAGE NAVI
 *********************/

// Numeric Page Navi (built into the theme by default)
if ( ! function_exists( 'geodirf_page_navi' ) ) {
	function geodirf_page_navi() {
		global $wp_query;
		$bignum = 999999999;
		if ( $wp_query->max_num_pages <= 1 ) {
			return;
		}
		echo '<nav class="pagination">';
		echo paginate_links( array(
			'base'      => str_replace( $bignum, '%#%', esc_url( get_pagenum_link( $bignum ) ) ),
			'format'    => '',
			'current'   => max( 1, get_query_var( 'paged' ) ),
			'total'     => $wp_query->max_num_pages,
			'prev_text' => '&larr;',
			'next_text' => '&rarr;',
			'type'      => 'list',
			'end_size'  => 3,
			'mid_size'  => 3
		) );
		echo '</nav>';
	} /* end page navi */
}


if ( ! function_exists( 'geodirf_get_image_params' ) ) {
	function geodirf_get_image_params( $url ) {

		// Split the $url into two parts with the wp-content directory as the separator.
		$parse_url = explode( parse_url( WP_CONTENT_URL, PHP_URL_PATH ), $url );

		// Get the host of the current site and the host of the $url, ignoring www.
		$this_host = str_ireplace( 'www.', '', parse_url( home_url(), PHP_URL_HOST ) );
		$file_host = str_ireplace( 'www.', '', parse_url( $url, PHP_URL_HOST ) );

		// Return nothing if there aren't any $url parts or if the current host and $url host do not match.
		if ( ! isset( $parse_url[1] ) || empty( $parse_url[1] ) || ( $this_host != $file_host ) ) {
			return;
		}

		// Now we're going to quickly search the DB for any attachment GUID with a partial path match.
		// Example: /uploads/2013/05/test-image.jpg
		global $wpdb;

		$attachment = $wpdb->get_col( $wpdb->prepare( "SELECT ID FROM {$wpdb->prefix}posts WHERE guid RLIKE %s;", $parse_url[1] ) );

		if ( $attachment[0] ) {
			$img = wp_get_attachment_image_src( $attachment[0] );

			return array(
				'url'       => $img[0],
				'id'        => $attachment[0],
				'height'    => $img[2],
				'width'     => $img[1],
				'thumbnail' => $img[0]
			);
		} else {
			return false;
		}


		return $attachment[0];
	}
}
